import { Injectable } from '@angular/core';
import {Http, Response } from '@angular/http';
import { Observable } from 'rxjs/Rx';
import { Menu } from './menu';

@Injectable()
export class MenusService {

  private menus: any;

  constructor(private http: Http) {}

  getMenus(): Observable<Menu[]> {
    return this.http.get('../../assets/config/menus.json').map(mapMenu);
  }

  save(menus: string) {

  }

}

function mapMenu(response: Response): Menu[] {
  return response.json().menus.map(toMenu);
}

function toMenu(r: any): Menu {
  const menu = <Menu>({
    title: r.title,
    uri: r.uri,
    subMenu: r.subMenu
  });
  return menu;
}
